/**
 * Beschrijft een projectleider.
 * 
 * @author Dominiek Vandewalle
 * @version 2016-05-20
 */
public class ProjectLeider extends Werknemer
{
    private int aantalTeamLeden;
    
    /**
     * Constructor voor objecten van de klasse ProjectLeider.
     * @param   naam            De naam van de projectleider.
     * @param   aantalTeamLeden Het aantal teamleden in het team van de projectleider.
     */
    public ProjectLeider(String naam, int aantalTeamLeden)
    {
        super(naam);
        this.aantalTeamLeden = aantalTeamLeden;
    }
    
    /**
     * Stelt het aantal teamleden van de projectleider in.
     * @param   aantalTeamLeden Het nieuw aantal teamleden.
     */
    public void setAantalTeamLeden(int aantalTeamLeden)
    {
        this.aantalTeamLeden = aantalTeamLeden;
    }
    
    /**
     * Berekent het aantal verlofdagen van de projectleider
     * @return  Het aantal verlofdagen.
     */
    public int berekenAantalVerlofDagen()
    {
        return super.berekenAantalVerlofDagen() + 3;
    }
    
    /**
     * Berekent het maandloon van de projectleider.
     * @return  Het maandloon van de projectleider.
     */
    public double berekenMaandloon()
    {
        return super.berekenMaandloon() + (100 * aantalTeamLeden);
    }
    
    /**
     * Toont informatie over de projectleider in het terminalvenster.
     */
    public void printInfo()
    {
        System.out.println("Projectleider " + getNaam());
        System.out.println("Aantal teamleden: " + aantalTeamLeden);
        System.out.println("Ancienniteit: " + ancienniteit);
    }
}
